//******************************************************************************
//
//	File:		InstantiateBBox.h
//
//	Description:	Unarchiving a BBox instance.
//
//	Copyright 1996, International Lorienne Inc.
//
//******************************************************************************

#include <Box.h>
#include "NiceBox.h"
#include <string.h>

#pragma export on
BBox* InstantiateBBox(BMessage *message);
#pragma export off


BBox* InstantiateBBox(BMessage *message)
{
	BBox	*instance;				// returned pointer
	BRect	frame;					// view frame
	long	follow;					// resizing mode
	char	*label = NULL;			// label
	rgb_color	color;				// view color
	
	// Default values	
	
	frame.left = 10;				// Default frame
	frame.top = 10;
	frame.right = 90;
	frame.bottom = 80;
	
	follow = B_FOLLOW_LEFT | B_FOLLOW_TOP;	// Default resizing mode
	
	color.red = 210;						// Default color
	color.green = 210;
	color.blue = 210;
	
	// Decoging values	
	if (message->HasPoint("Origin")) {						// Dropped
		frame.OffsetTo(message->FindPoint("Origin"));
	}	
	if (message->HasRect("Frame")) {						// Frame
		frame = message->FindRect("Frame");
	}	
	if (message->HasLong("Follow Mode")) {					// Resising mode
		follow = message->FindLong("Follow Mode");
	}
	if (message->HasString("Label")) {						// Label
		label = strdup(message->FindString("Label"));
	}	
	if (message->HasData("View Color",B_RGB_COLOR_TYPE)) {
		long size;
		color = *((rgb_color *) message->FindData("View Color",B_RGB_COLOR_TYPE,&size));			// Color
	}
	else {
		message->AddData("View Color",B_RGB_COLOR_TYPE,(const void *)(&color),sizeof(rgb_color));
	}
	
	instance = new NiceBox(frame,"BBox",follow,B_FULL_UPDATE_ON_RESIZE|B_WILL_DRAW);

	if (label) {										// Set label
		instance->SetLabel(label);
		free(label);
	}
	else instance->SetLabel("Box");						// Default label is "Box"
	instance->SetViewColor(color);						// Set view color
	instance->SetLowColor(color);						// Set low color, to have a correct redrawing
														// of what is beneath the text...
	
	if (message->HasString("Font Name")) {				// Set font, if there is one
		instance->SetFontName(message->FindString("Font Name"));
	}	

	return instance;

}